<?php

class Gross_net_report_model extends CI_Model {

    function __construct()
    {
        parent::__construct();
    }
    
    function get_bookings_for_report($filters, $company_id = 0, $group_by1 = NULL)
    {
        if ($company_id == 0)
        {
            $company_id = $this->session->userdata('current_company_id');
        }
        
        // set order by
        $order_by = "";
        if (isset($filters['order_by'])) {
            // if both $star and $end are set, then return occupancies within range
            if ($filters['order_by'] != "") {
                $order_by = "ORDER BY ".$filters['order_by'];
            }
            else
            {
                $order_by = "ORDER BY bl.date_time";
            }
        }

        // set order
        $order = "";
        if (isset($filters['order'])) {
            if ($filters['order'] != "") {
                if ($filters['order'] == 'DESC') {
                    $order = "DESC";
                }
                if ($filters['order'] == 'ASC') {
                    $order = "ASC";
                }
            }
            else
            {
                $order = "DESC";
            }
        }
        
        $sql = "SELECT 
                    b.*,
                    c.customer_id,
                    c.customer_name,
                    r.room_id,
                    r.room_name,
                    rt.name as room_type_name,
                    brh.check_in_date, 
                    brh.check_out_date, 
                    cm.name as company_name                    
                FROM 
                    `booking` b             
                LEFT JOIN customer c 
                    ON c.customer_id = b.booking_customer_id                
                LEFT JOIN booking_block as brh 
                    ON brh.booking_id = b.booking_id
                LEFT JOIN room as r
                    ON brh.room_id = r.room_id
                LEFT JOIN room_type as rt
                    ON rt.id = r.room_type_id
                LEFT JOIN booking_log bl 
                    ON bl.booking_id = b.booking_id
                LEFT JOIN company as cm 
                    ON cm.company_id = b.company_id
                LEFT JOIN booking_staying_customer_list as bscl ON bscl.booking_id = b.booking_id
                LEFT JOIN customer as sg ON bscl.customer_id = sg.customer_id
                WHERE
                b.company_id = '$company_id' AND
                b.is_deleted != 1
                AND '".$filters['date']."' >= Date(brh.check_in_date) AND '".$filters['date']."' <= Date(brh.check_out_date)
                GROUP BY b.booking_id
                $order_by $order";
        
        $q = $this->db->query($sql);
        
        if ($this->db->_error_message())
        {
            show_error($this->db->_error_message());
        }

        $result = $q->result_array();
        
        return $result;
    }

    function get_payments($booking_id, $customer_id = false, $folio_id = null, $is_first_folio = false)
    {
        $this->db->where("booking_id IN ($booking_id)");
        
        if($is_first_folio) {
            $this->db->where("(folio_id = '$folio_id' OR folio_id IS NULL OR folio_id = 0)");
        } elseif($folio_id) {
            $this->db->where('folio_id', $folio_id);
        }
        
        if ($customer_id != false)
            $this->db->where('payment.customer_id', $customer_id);
        $this->db->where('payment.is_deleted', '0');
        $this->db->join('payment_folio' , 'payment.payment_id = payment_folio.payment_id', 'left');
        $this->db->join('payment_type', 'payment.payment_type_id = payment_type.payment_type_id', 'left');
        $this->db->join('user_profiles', 'payment.user_id = user_profiles.user_id', 'left');
        $this->db->join('customer', 'payment.customer_id = customer.customer_id', 'left');
        $this->db->select('payment.payment_id, payment.is_captured, description, customer_name, date_time, booking_id, amount, payment_status, payment.is_deleted, payment_type, payment.payment_type_id, payment.payment_gateway_used, gateway_charge_id, read_only, selling_date, CONCAT_WS(" ",first_name,  last_name ) as user_name,payment_folio.folio_id as folio_id, payment.payment_link_id');
        $this->db->order_by('selling_date', 'ASC');
        $this->db->order_by('date_time', 'ASC');
        $query = $this->db->get("payment");
        if ($this->db->_error_message())
            show_error($this->db->_error_message());
        if ($query->num_rows() > 0) {
            return $query->result_array();
        }
    }

    function get_partial_refunds_by_charge_id($charge_id)
    {
        $this->db->where('parent_charge_id', $charge_id);
        $this->db->where('payment_status', 'partial');
        $query = $this->db->get('payment');
      
        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return null;
        }
    }
}
